package com.eni.android.actionbar;

import android.app.ActionBar;
import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

public class ActionBarExempleActivity extends Activity {
	private static final String ACTION_BAR_EXEMPLE_ACTIVITY = "ActionBarExempleActivity";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	/**
	 * Creation de l'ActionBar
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.actionbar, menu);
		ActionBar actionBar = getActionBar();
		actionBar.setDisplayHomeAsUpEnabled(true);
		return true;
	}

	/**
	 * Gestion du clic sur l'ActionBar
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.menu_exit:
			Log.v(ACTION_BAR_EXEMPLE_ACTIVITY, getString(R.string.bouton_quitter_cliqu_));
			return true;
		case R.id.menu_help:
			Log.v(ACTION_BAR_EXEMPLE_ACTIVITY, getString(R.string.bouton_aide_cliqu_));
			return true;
		case R.id.menu_link:
			Log.v(ACTION_BAR_EXEMPLE_ACTIVITY, getString(R.string.bouton_liens_cliqu_));
			return true;
		case R.id.menu_search:
			Log.v(ACTION_BAR_EXEMPLE_ACTIVITY, getString(R.string.bouton_recherche_cliqu_));
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

}