package com.eni.android.tts;

import java.util.Locale;

import android.app.Activity;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TextToSpeech.OnInitListener;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class TTSSampleActivity extends Activity
{
	private EditText ttsEditText;
	private Button ttsButton;
	private TextToSpeech tts;
	private TextToSpeech.OnInitListener ttsListener = new OnInitListener() {
		@Override
		public void onInit(int status) {
			if (status == TextToSpeech.SUCCESS) {
				tts.setLanguage(Locale.getDefault());
			}
		}
	};
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		setContentView(R.layout.tts);
		
		tts = new TextToSpeech(this, ttsListener);
		ttsEditText = (EditText) findViewById(R.id.tts);
		ttsButton = (Button) findViewById(R.id.ttsBtn);
		
		ttsButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				String text = ttsEditText.getText().toString();
				tts.speak(text, TextToSpeech.QUEUE_FLUSH, null);
			}
		});
	}
	
	@Override
	protected void onStop() {
		super.onStop();
		if (tts != null) {
			tts.stop();
			tts.shutdown();
		}
	}
}
