package com.eni.android.sensor;

import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;

public class SensorActivity extends Activity{

	private static final String SENSOR_ACTIVITY = "SensorActivity";

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		final SensorManager sensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		
		List<Sensor> sensorsList = sensorManager.getSensorList(Sensor.TYPE_ALL);
		
		for (Sensor sensor : sensorsList) {
			Log.v(SENSOR_ACTIVITY, "sensor = " + sensor.getName());
		}
		
		Sensor defaultProximitySensor = sensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);
		Log.v(SENSOR_ACTIVITY, "defaultProximitySensor = " + defaultProximitySensor.getName());
	}
}
