package com.eni.android.bluetooth;

import java.util.Set;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

public class BluetoothActivity extends Activity {

	private int BLUETOOTH_ACTIVATION = 0;
	private int BLUETOOTH_SCAN = 1;
	private Set<BluetoothDevice> knownDevices;
	private final String ACTION_DISCOVER_START = BluetoothAdapter.ACTION_DISCOVERY_STARTED;
	private final String ACTION_DISCOVER_END = BluetoothAdapter.ACTION_DISCOVERY_FINISHED;
	private BluetoothAdapter bluetoothAdapter;
	private BroadcastReceiver discoverDevicesStarted = new BroadcastReceiver() {
		
		@Override
		public void onReceive(Context context, Intent intent) {
			if (intent.getAction().equals(ACTION_DISCOVER_START)) {
				//Debut de la decouverte de nouveaux appareils
			} else if (intent.getAction().equals(ACTION_DISCOVER_END)) {
				//Fin de la decouverte de nouveaux appareils
			} else if (BluetoothDevice.ACTION_FOUND.equals(intent.getAction())) {
				if (intent != null && intent.hasExtra(BluetoothDevice.EXTRA_DEVICE)) {
					@SuppressWarnings("unused")
					BluetoothDevice newDevice = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
				}
			}
		};
	};
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
		
		if (bluetoothAdapter != null) {
			Toast.makeText(this, R.string.cet_appareil_poss_de_la_technologie_bluetooth, Toast.LENGTH_LONG).show();
		} else {
			Toast.makeText(this, R.string.cet_appareil_ne_poss_de_pas_la_technologie_bluetooth, Toast.LENGTH_LONG).show();
		}
		
		/* Activation forcee */
		bluetoothAdapter.enable();
		
		/* Activation demandant l'autorisation de l'utilisateur */
		if(!bluetoothAdapter.isEnabled()) {
			startActivityForResult(new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE), BLUETOOTH_ACTIVATION);
		} else {
			Toast.makeText(this, R.string.le_bluetooth_est_d_ja_activ_ + bluetoothAdapter.getName(), Toast.LENGTH_LONG).show();
		}
		
		startActivityForResult(new Intent(BluetoothAdapter.ACTION_REQUEST_DISCOVERABLE), BLUETOOTH_SCAN);
	
		knownDevices = bluetoothAdapter.getBondedDevices();
		for (BluetoothDevice device : knownDevices) {
			Log.v("BluetoothActivity", getString(R.string.appareil_) + device.getName());
		}
		
		
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		registerReceiver(discoverDevicesStarted, new IntentFilter(ACTION_DISCOVER_START));
		registerReceiver(discoverDevicesStarted, new IntentFilter(ACTION_DISCOVER_END));
		bluetoothAdapter.startDiscovery();
	}
	
	@Override
	protected void onPause() {
		super.onPause();
		unregisterReceiver(discoverDevicesStarted);
		bluetoothAdapter.cancelDiscovery();
	}
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		if (requestCode == BLUETOOTH_ACTIVATION) {
			if (resultCode == RESULT_OK) {
				Toast.makeText(BluetoothActivity.this, R.string.l_utilisateur_a_activ_le_bluetooth, Toast.LENGTH_LONG).show();
			} else {
				Toast.makeText(BluetoothActivity.this, R.string.l_utilisateur_n_a_pas_activ_le_bluetooth, Toast.LENGTH_LONG).show();
			}
		}
		if (requestCode == BLUETOOTH_SCAN) {
			
		}
	}
}
