package com.eni.android.map;

import java.util.ArrayList;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;

import com.google.android.maps.ItemizedOverlay;
import com.google.android.maps.OverlayItem;

public class ListeMarqueurs extends ItemizedOverlay<OverlayItem> {

	private ArrayList<OverlayItem> overlayList;
	private Context context;

	public ListeMarqueurs(Drawable drawable, Context context) {
		super(boundCenter(drawable));
		overlayList = new ArrayList<OverlayItem>();
		this.context = context;
	}

	@Override
	protected OverlayItem createItem(int pos) {
		return overlayList.get(pos);
	}

	@Override
	public int size() {
		return overlayList.size();
	}

	public void addItemToOverlayList(OverlayItem item) {
		overlayList.add(item);
		populate();
	}

	@Override
	protected boolean onTap(int index) {
		OverlayItem item = overlayList.get(index);
		AlertDialog.Builder dialog = new AlertDialog.Builder(context);
		dialog.setTitle(item.getTitle());
		dialog.setMessage(item.getSnippet());
		dialog.show();
		return true;
	}

}
