package com.eni.android.share.data;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class Ch11_PartageDonneesExempleActivity extends Activity {

	private EditText shareSubject;
	private EditText shareMessage;
	private Button shareBtn; 
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        shareSubject = (EditText) findViewById(R.id.shareSubject);
        shareMessage = (EditText) findViewById(R.id.shareMessage);
        shareBtn = (Button) findViewById(R.id.shareBtn);
        
        shareBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
		        Intent intent=new Intent(android.content.Intent.ACTION_SEND);
		        intent.setType("text/plain");
		        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_WHEN_TASK_RESET);
		        intent.putExtra(Intent.EXTRA_SUBJECT, shareSubject.getText().toString());
		        intent.putExtra(Intent.EXTRA_TEXT, shareMessage.getText().toString());
		        startActivity(Intent.createChooser(intent, getResources().getString(R.string.shareData)));
			}
		});
    
	}
}