package com.eni.android.stockage;

import java.io.File;

import android.app.Activity;
import android.os.Bundle;
import android.os.Environment;

public class Ch10_StockageExterneExempleActivity extends Activity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		final String storageState = Environment.getExternalStorageState();

		if (storageState.equals(Environment.MEDIA_MOUNTED)) {
			//Vous pouvez lire et ecrire sur le stockage externe
			@SuppressWarnings("unused")
			File outFile = getExternalFilesDir(Environment.DIRECTORY_DCIM);
		} else if (storageState.equals(Environment.MEDIA_MOUNTED_READ_ONLY)) {
			//Vous pouvez seulement lire sur le stockage externe 
			@SuppressWarnings("unused")
			File sharedFile = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM);
		} else if (storageState.equals(Environment.MEDIA_REMOVED)) {
			//Le stockage externe n'est pas disponible
		} else {
			//Autre cas
		}
	}
}