package com.eni.android.database;

import java.util.ArrayList;

import android.app.Activity;
import android.os.Bundle;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class Ch10_BaseDeDonneesExempleActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        ListView list = (ListView) findViewById(R.id.chapterList);
        
        Chapitre chapitre1 = new Chapitre(getString(R.string.la_plateform_android), getString(R.string.pr_sentation_et_historique_de_la_plateform_android));
        Chapitre chapitre2 = new Chapitre(getString(R.string.environnement_de_d_veloppement), getString(R.string.pr_sentation_et_installation_de_l_environnement_de_developpement_android));
        Chapitre chapitre3 = new Chapitre(getString(R.string.principe_de_programmation), getString(R.string.pr_sentation_des_sp_cificit_s_de_developpement_android));
        Chapitre chapitre4 = new Chapitre(getString(R.string.ma_premi_re_application_helloandroid), getString(R.string.cr_ation_du_premier_projet_android_et_explication_de_l_architecture_d_un_projet_android));
        Chapitre chapitre5 = new Chapitre(getString(R.string.d_bogage_et_gestion_des_erreurs), getString(R.string.explication_de_la_mani_re_de_deboger_une_application_android));
        Chapitre chapitre6 = new Chapitre(getString(R.string.cr_ation_d_interfaces_simples), getString(R.string.introduction_la_cr_ation_d_interfaces_sous_android));

        ChapitreBDD chapitreBdd = new ChapitreBDD(this);
        chapitreBdd.openForWrite();
        chapitreBdd.insertChapter(chapitre1);
        chapitreBdd.insertChapter(chapitre2);
        chapitreBdd.insertChapter(chapitre3);
        chapitreBdd.insertChapter(chapitre4);
        chapitreBdd.insertChapter(chapitre5);
        chapitreBdd.insertChapter(chapitre6);
        
        ArrayList<Chapitre> chapterList = chapitreBdd.getAllChapters();
        chapitreBdd.close();
        ArrayAdapter<Chapitre> adapter = new ArrayAdapter<Chapitre>(this, android.R.layout.simple_list_item_1, chapterList);
        list.setAdapter(adapter);
     
    }
}