package fr.univ.amu.iut.iutinfogame;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.support.v7.app.ActionBarActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import android.widget.SimpleAdapter;

public class MainScreenActivity extends ActionBarActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.activity_mainscreen);
		if (savedInstanceState == null) {
			getSupportFragmentManager().beginTransaction().add(R.id.container, new PlaceholderFragment()).commit();
		}
	}

	/**
	 * A placeholder fragment containing a simple view.
	 */
	public static class PlaceholderFragment extends ListFragment {


		public PlaceholderFragment() {
		}

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container,
				Bundle savedInstanceState) {
			View rootView = inflater.inflate(R.layout.fragment_mainscreen, container, false);

			setListAdapter(new SimpleAdapter(getActivity(), getData(),
					android.R.layout.simple_list_item_1, new String[] { "title" },
					new int[] { android.R.id.text1 }));
			//			        getListView().setTextFilterEnabled(true);

			return rootView;
		}

		protected List<Map<String, Object>> getData() {
			List<Map<String, Object>> myData = new ArrayList<Map<String, Object>>();

			Intent mainIntent = new Intent(Intent.ACTION_MAIN, null);
			mainIntent.addCategory(Constants.INTENT_CATEGORY_IUT_GAME);

			PackageManager pm = getActivity().getPackageManager();
			List<ResolveInfo> list = pm.queryIntentActivities(mainIntent, 0);

			if (null == list)
				return myData;

			for (ResolveInfo info : list) {
				addItem(myData, getTitleFromName(info.activityInfo.name), activityIntent(
						info.activityInfo.applicationInfo.packageName,
						info.activityInfo.name));
			}


			Collections.sort(myData, sDisplayNameComparator);

			return myData;
		}

		private final static Comparator<Map<String, Object>> sDisplayNameComparator =
				new Comparator<Map<String, Object>>() {
			private final Collator   collator = Collator.getInstance();

			public int compare(Map<String, Object> map1, Map<String, Object> map2) {
				return collator.compare(map1.get("title"), map2.get("title"));
			}
		};

		protected Intent activityIntent(String pkg, String componentName) {
			Intent result = new Intent();
			result.setClassName(pkg, componentName);
			return result;
		}

		protected void addItem(List<Map<String, Object>> data, String name, Intent intent) {
			Map<String, Object> temp = new HashMap<String, Object>();
			temp.put("title", name);
			temp.put("intent", intent);
			data.add(temp);
		}

		protected String getTitleFromName(String name) {
			String[] splittedName = name.split("\\.");
			int length = splittedName.length;

			return splittedName[length-2] + " / " + splittedName[length-1].substring(0, splittedName[length-1].length()-8);
		}

		@Override
		@SuppressWarnings("unchecked")
		public void onListItemClick(ListView l, View v, int position, long id) {
			Map<String, Object> map = (Map<String, Object>)l.getItemAtPosition(position);

			Intent intent = (Intent) map.get("intent");
			startActivity(intent);
		}
	}
}
