package com.eni.android.webview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;

public class Ch8_WebViewPageDistanteExampleActivity extends Activity {
	String WEB_CONTENT = "<input type=\"button\" value=\"Test Javascript\" onClick=\"showAndroidToast(\'Un toast cree en Javascript!\')\" /><script type=\"text/javascript\">function showAndroidToast(toast) {Android.showToast(toast);}</script>";

	@SuppressLint("SetJavaScriptEnabled")
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		WebView webView = (WebView) findViewById(R.id.webview);
		WebSettings settings = webView.getSettings();
		/*Attention, l'activation du JavaScript peut entrainer des vulnerabilites sur vos applications*/
		settings.setJavaScriptEnabled(true);
		webView.addJavascriptInterface(new JavaScriptToastInterface(this),
				"Android");
		webView.loadData(WEB_CONTENT, "text/html", "UTF-8");
	}

	public class JavaScriptToastInterface {
		Context context;

		JavaScriptToastInterface(Context c) {
			context = c;
		}

		public void showToast(String toastMsg) {
			Toast.makeText(context, toastMsg, Toast.LENGTH_SHORT).show();
		}
	}
}