package com.eni.android.dynamic;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.LinearLayout.LayoutParams;

public class DynamicViewActivity extends Activity {

	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        final LinearLayout linearLayout = (LinearLayout) findViewById(R.id.linearlayout);
        Button btn = (Button) findViewById(R.id.addBtn);
        btn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				EditText edit = new EditText(DynamicViewActivity.this);
				edit.setHint(R.string.newEditText);
				LayoutParams layoutParams = new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
				edit.setLayoutParams(layoutParams);
				linearLayout.addView(edit);
			}
		});
    }
}