package com.eni.android.customadapter;

import java.util.ArrayList;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class AndroidAdapter extends ArrayAdapter<AndroidVersion> {

	ArrayList<AndroidVersion> androidVer;
	Context context;
	int viewRes;

	public AndroidAdapter(Context context, int textViewResourceId,
			ArrayList<AndroidVersion> versions) {
		super(context, textViewResourceId, versions);
		this.androidVer = versions;
		this.context = context;
		this.viewRes = textViewResourceId;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View v = convertView;
		if (v == null) {
			LayoutInflater vi = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			v = vi.inflate(viewRes, parent, false);
		}
		AndroidVersion o = androidVer.get(position);
		if (o != null) {
			TextView tt = (TextView) v.findViewById(R.id.title);
			TextView bt = (TextView) v.findViewById(R.id.description);
			if (tt != null) {
				tt.setText(R.string.nom_de_la_version_ + o.getVersionName());
			}
			if (bt != null) {
				bt.setText(R.string.num_ro_de_la_version_ + o.getVersionNumber());
			}
		}
		return v;
	}
}
