package com.eni.android.action;

import java.io.File;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.widget.Toast;

public class Ch7_TrouverActionExecuterActivity extends Activity {
	private static final String APPLICATION_PDF = "application/pdf";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		File externalDirectory = Environment.getExternalStorageDirectory();
		if (externalDirectory.canRead()) {
			String fileName = "/exemple.pdf";
			String pathFile = externalDirectory.getAbsoluteFile() + fileName;
			File file = new File(pathFile);

			if (file.exists()) {
				Uri path = Uri.fromFile(file);
				Intent intent = new Intent(Intent.ACTION_VIEW);
				intent.setDataAndType(path, APPLICATION_PDF);

				PackageManager pm = getPackageManager();
				ComponentName component = intent.resolveActivity(pm);
				
				if (component == null) {
					Toast.makeText(Ch7_TrouverActionExecuterActivity.this,
							R.string.aucune_application_ne_peut_ouvrir_un_fichier_pdf,
							Toast.LENGTH_SHORT).show();
				} else {
					startActivity(intent);
				}
			}
		}
	}
}