package com.eni.android.activity.result;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class Ch7_ActivityResultExempleActivity extends Activity {
	private static final String ACTIVITY_RESULT = "ActivityResult";

	private Button result;
	
	private final int RESULT_SELECTION = 0;
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        result = (Button) findViewById(R.id.result);
        result.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				/* Executer l'activite cible */
				Intent intent = new Intent(Ch7_ActivityResultExempleActivity.this, ChoixResultatActivity.class);
				startActivityForResult(intent, RESULT_SELECTION);
			}
		});
    }
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		/* Recuperer le resultat de l'activation */
		if (requestCode == RESULT_SELECTION) {
			if (resultCode == RESULT_OK) {
				Log.v(ACTIVITY_RESULT, getString(R.string.result_ok));
			} else {
				Log.v(ACTIVITY_RESULT, getString(R.string.result_ko));				
			}
		}
	}
}