package com.eni.android.clickListener;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class Ch6_ClickListenerMethod1Activity extends Activity {

	private static final String CLICK_LISTENER = "ClickListener";

	/**
	 * Chaque bouton possede son listener
	 */
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        Button btn1 = (Button) findViewById(R.id.btn1);
        btn1.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.v(CLICK_LISTENER, getString(R.string.interaction_avec_le_bouton_1));
			}
		});

        Button btn2 = (Button) findViewById(R.id.btn2);
        btn2.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.v(CLICK_LISTENER, getString(R.string.interaction_avec_le_bouton_2));
			}
		});

	
	}
}