package com.eni.android.camera;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Bundle;
import android.provider.MediaStore;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;

public class TakePictureActivity extends Activity {

	private static final int IMAGE_CAPTURE = 0;
	private static final int MEDIA_TYPE_VIDEO = 1;

	ImageView pictureImg;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.take_picture);

		Camera camera = Camera.open();
		Camera.Parameters param = camera.getParameters();
		param.setJpegQuality(100);
		camera.setParameters(param);
		camera.release();

		Button takePicture = (Button) findViewById(R.id.take_picture);
		takePicture.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				startActivityForResult(new Intent(
						MediaStore.ACTION_IMAGE_CAPTURE), IMAGE_CAPTURE);
			}
		});

		pictureImg = (ImageView) findViewById(R.id.picture);

	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		if (requestCode == IMAGE_CAPTURE) {
			if (data != null) {
				Bitmap picture = data.getParcelableExtra("data");
				if (picture != null) {
					// Effectuer le traitement avec l'image recu
					pictureImg.setImageBitmap(picture);
				}
			}
		}
	}
}
