package com.eni.android.data;

import android.app.Activity;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.widget.Toast;

public class Ch14_EtatConnectiviteDonneesExempleActivity extends Activity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		/**
		 * Creation du listener sur l'etat de la connectivite d'un appareil (sauf wifi)
		 */
		PhoneStateListener dataState = new PhoneStateListener() {
			@Override
			public void onDataConnectionStateChanged(int state) {
				switch (state) {
				case TelephonyManager.DATA_CONNECTED:
					Toast.makeText(Ch14_EtatConnectiviteDonneesExempleActivity.this, R.string.appareil_connect_, Toast.LENGTH_LONG).show();
					break;
				case TelephonyManager.DATA_CONNECTING:
					Toast.makeText(Ch14_EtatConnectiviteDonneesExempleActivity.this, R.string.appareil_en_cours_de_connexion, Toast.LENGTH_LONG).show();
					break;
				case TelephonyManager.DATA_DISCONNECTED:
					Toast.makeText(Ch14_EtatConnectiviteDonneesExempleActivity.this, R.string.appareil_deconnect_, Toast.LENGTH_LONG).show();
					break;
				case TelephonyManager.DATA_SUSPENDED:
					Toast.makeText(Ch14_EtatConnectiviteDonneesExempleActivity.this, R.string.appareil_connecte_mais_transfert_de_donnees_est_indisponible, Toast.LENGTH_LONG).show();
					break;
				}
				super.onDataConnectionStateChanged(state);
			}
		};

		/**
		 * Ajout du listener
		 */
		TelephonyManager tm = (TelephonyManager) getSystemService(TELEPHONY_SERVICE);
		tm.listen(dataState, PhoneStateListener.LISTEN_DATA_CONNECTION_STATE);

		/**
		 * Recuperation d'un ConnectivityManager
		 */
		ConnectivityManager cm = (ConnectivityManager) getSystemService(CONNECTIVITY_SERVICE);
		NetworkInfo networkInfo = cm.getActiveNetworkInfo();
		boolean isConnected = false;
		if (networkInfo != null && networkInfo.isConnectedOrConnecting())
			isConnected = true;
		Toast.makeText(Ch14_EtatConnectiviteDonneesExempleActivity.this, "is connected = " + isConnected, Toast.LENGTH_LONG).show();
		
		/**
		 * Tester si la connexion correspond a une connexion WIFI
		 */
		boolean isWifi = false;
		if (networkInfo.getType() == ConnectivityManager.TYPE_WIFI)
			isWifi = true;
		Toast.makeText(Ch14_EtatConnectiviteDonneesExempleActivity.this, "is wifi = " + isWifi, Toast.LENGTH_LONG).show();
	}
}