package com.eni.android.asynctask;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.Toast;

public class AsyncTaskActivity extends Activity {

	private Button launchAsync;
	private ProgressBar progress;
	private Thread downloadThread;
	private static Handler downloadHandler;
	private static final int MESSAGE_PRE_EXECUTE = 1;
	private static final int MESSAGE_PROGRESS_UPDATE = 2;	
	private static final int MESSAGE_POST_EXECUTE = 3;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.async_task);

		launchAsync = (Button) findViewById(R.id.launch_async);
		progress = (ProgressBar) findViewById(R.id.progress);
		downloadHandler = new Handler() {
			@Override
			public void handleMessage(Message msg) {
				super.handleMessage(msg);
				switch (msg.what) {
				case MESSAGE_PRE_EXECUTE:
					downloadOnPreExecute();
					break;
				case MESSAGE_PROGRESS_UPDATE:
					downloadOnProgressUpdate(msg.arg1);
					break;
				case MESSAGE_POST_EXECUTE:
					downloadOnPostExecute();
					break;
				default:
					break;
				}
			}
		};
		
		downloadThread = new Thread(new Runnable() {
			@Override
			public void run() {
				
				sendPreExecuteMessage();
			
				for (int i = 1; i <= 10; ++i) {
					try {
						Thread.sleep(1000L);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
					
					sendProgressMessage(i);
				}
				
				sendPostExecuteMessage();
			}

			private void sendPostExecuteMessage() {
				Message postExecuteMsg = new Message();
				postExecuteMsg.what = MESSAGE_POST_EXECUTE;
				downloadHandler.sendMessage(postExecuteMsg);
			}

			private void sendPreExecuteMessage() {
				Message preExecuteMsg = new Message();
				preExecuteMsg.what = MESSAGE_PRE_EXECUTE;
				downloadHandler.sendMessage(preExecuteMsg);
			}
			
			private void sendProgressMessage(int i) {
				Message progressMsg = new Message();
				progressMsg.what = MESSAGE_PROGRESS_UPDATE;
				progressMsg.arg1 = i * 10;
				downloadHandler.sendMessage(progressMsg);
			}
			
			
		});

		launchAsync.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				if (!downloadThread.isAlive())
					downloadThread.start();
			}
		});

	}

	private void downloadOnPreExecute() {
		launchAsync.setVisibility(View.GONE);
		progress.setVisibility(View.VISIBLE);
	}

	protected void downloadOnProgressUpdate(int progress) {
		AsyncTaskActivity.this.progress.setProgress(progress);
	}

	protected void downloadOnPostExecute() {
		Toast.makeText(AsyncTaskActivity.this,
				R.string.fin_de_l_ex_cution_du_traitement_en_arri_re_plan,
				Toast.LENGTH_LONG).show();
		launchAsync.setVisibility(View.VISIBLE);
		progress.setVisibility(View.GONE);
	}

}
