package com.eni.android.alarme;

import java.util.Calendar;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class MyCustomAlarm extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button launch = (Button) findViewById(R.id.launchMap);
		launch.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				/**
				 * Dans cet exemple, le service sera cree 30 secondes apres
				 * l'appuie sur le bouton de l'interface
				 */
				Intent serviceIntent = new Intent(MyCustomAlarm.this,
						MyAlarmService.class);
				PendingIntent pendingIntent = PendingIntent.getService(
						MyCustomAlarm.this, 0, serviceIntent, 0);
				/**
				 * Recuperation de l'AlarmManager
				 */
				AlarmManager am = (AlarmManager) getSystemService(ALARM_SERVICE);
				/**
				 * Specification d'un temps de declanchement
				 */
				Calendar calendar = Calendar.getInstance();
				calendar.setTimeInMillis(System.currentTimeMillis());
				calendar.add(Calendar.SECOND, 30);
				/**
				 * Ajout d'une une nouvelle alarme
				 */
				am.set(AlarmManager.RTC_WAKEUP, calendar.getTimeInMillis(),
						pendingIntent);
			}
		});

	}

}
