package com.eni.android.database;

import android.app.Activity;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;

public class Ch10_BaseDeDonneesExempleActivity extends Activity {
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		insertRecords();
		displayContentProvider();
	}

	private void displayContentProvider() {
		String columns[] = new String[] { ChapitreBDD.COL_ID,
				ChapitreBDD.COL_NAME, ChapitreBDD.COL_DESC };
		Uri mContacts = ChapitreContentProvider.contentUri;
		Cursor cur = getContentResolver().query(mContacts, columns, null, null,
				null);

		if (cur.moveToFirst()) {
			String name = null;
			do {
				name = cur.getString(cur.getColumnIndex(ChapitreBDD.COL_ID))
						+ " "
						+ cur.getString(cur
								.getColumnIndex(ChapitreBDD.COL_NAME))
						+ " "
						+ cur.getString(cur
								.getColumnIndex(ChapitreBDD.COL_DESC));
				Toast.makeText(this, name + " ", Toast.LENGTH_LONG).show();
			} while (cur.moveToNext());
		}
	}

	private void insertRecords() {
		ContentValues contact = new ContentValues();
		contact.put(ChapitreBDD.COL_NAME, getString(R.string.chapitre_1));
		contact.put(ChapitreBDD.COL_DESC,
				getString(R.string.pr_sentation_de_la_plateform_android));
		getContentResolver()
				.insert(ChapitreContentProvider.contentUri, contact);

		contact.clear();
		contact.put(ChapitreBDD.COL_NAME, getString(R.string.chapitre_2));
		contact.put(ChapitreBDD.COL_DESC, getString(R.string.environnement_de_d_veloppement));
		getContentResolver()
				.insert(ChapitreContentProvider.contentUri, contact);

		contact.clear();
		contact.put(ChapitreBDD.COL_NAME, getString(R.string.chapitre_3));
		contact.put(ChapitreBDD.COL_DESC,
				getString(R.string.principes_de_programmation_sous_android));
		getContentResolver()
				.insert(ChapitreContentProvider.contentUri, contact);
	}

}