package com.eni.android.sharedPref;

import android.app.Activity;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;

public class Ch10_SharedPreferencesExempleActivity extends Activity {

	private String SHARED_KEY = "mysharedkey";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		SharedPreferences myPref = getPreferences(MODE_PRIVATE);
		SharedPreferences.Editor editor = myPref.edit();
		editor.putBoolean(SHARED_KEY, true);
		editor.commit();

		@SuppressWarnings("unused")
		boolean myValue = myPref.getBoolean(SHARED_KEY, false);

		myPref.registerOnSharedPreferenceChangeListener(new OnSharedPreferenceChangeListener() {
			@Override
			public void onSharedPreferenceChanged(
					SharedPreferences sharedPreferences, String key) {
				// Verifier le sharedPreference et la cle cibles
			}
		});

		editor.remove(SHARED_KEY);

	}
}