package formation06generiques

abstract class Animal(val size: Int)
class Dog(val cuteness: Int): Animal(100)
class Spider(val terrorFactor: Int): Animal(1)

interface Compare<in T> {
    fun compare(first: T, second: T): Int
}

val dogCompare: Compare<Dog> = object:
    Compare<Dog> {
    override fun compare(first: Dog, second: Dog): Int {
        return first.cuteness - second.cuteness
    }
}

val animalCompare: Compare<Animal> = object:
    Compare<Animal> {
    override fun compare(first: Animal, second: Animal): Int {
        return first.size - second.size
    }
}
val spiderCompare: Compare<Spider> =
    animalCompare // Works nicely!


fun main() {
    val dog: Dog = Dog(10)
    val spider: Spider = Spider(9000)
    var animal: Animal = dog
    animal = spider

    val dogList: List<Dog> = listOf(Dog(10), Dog(20))
    val animalList: List<Animal> = dogList
}