package formation05delegation

import kotlin.reflect.KProperty

class ExampleBis {
    val someName by Delegate()
}
class Delegate {
    operator fun getValue(thisRef: Any?, property: KProperty<*>): String {
        return "$thisRef, thank you for delegating '${property.name}' to me!"
    }

    operator fun setValue(thisRef: Any?, property: KProperty<*>, value: String) {
        println("$value has been assigned to '${property.name}' in $thisRef.")
    }
}


fun main() {
    var example = ExampleBis()
    println(example.someName);
}