package com.example.testsuite;

import android.os.RemoteException;

import androidx.test.ext.junit.runners.AndroidJUnit4;
import androidx.test.uiautomator.UiDevice;

import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

import static org.hamcrest.CoreMatchers.notNullValue;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.fail;

/**
 * Instrumented test, which will execute on an Android device.
 *
 * @see <a href="http://d.android.com/tools/testing">Testing documentation</a>
 */
@RunWith(AndroidJUnit4.class)
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class ExampleInstrumentedTest {

    private static final int LAUNCH_TIMEOUT = 5000;
    private static final String CURRENT_APP_PACKAGE = "com.example.sendsms";
    private static final String APP_NAME = "SendSMS";
    private UiDevice mDevice;

    @Before
    public void init() {
        mDevice = Utils.init();
    }

    @Test
    public void test001CheckPreconditions() {
        try {
            mDevice.wakeUp();
        } catch (RemoteException e) {
            e.printStackTrace();
            fail("Crash " + e.toString());
        }

        Utils.startMainActivityFromHomeScreen(mDevice, CURRENT_APP_PACKAGE, LAUNCH_TIMEOUT);

        assertThat(mDevice, notNullValue());
    }

    @Test
    public void test002CleanAppDatas() {
        Utils.cleanData(mDevice, APP_NAME, LAUNCH_TIMEOUT);
    }

    @Test
    public void test101ActivateWiFi(){
        Utils.setWiFi(mDevice, true);
        Utils.sleep(mDevice, 3000);
        Utils.setWiFi(mDevice, false);
    }

}
