package com.example.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;

import androidx.appcompat.app.AppCompatActivity;

import java.util.List;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "MainActivity";

    private SensorManager mSensorManager = null;
    private Sensor mProximitySensor = null;

    final SensorEventListener mSensorEventListener = new SensorEventListener() {
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
            // Que faire en cas de changement de précision ?
        }

        public void onSensorChanged(SensorEvent sensorEvent) {
            if(BuildConfig.DEBUG){
                Log.d(TAG, "onSensorChanged " + sensorEvent.values.length);
                Log.d(TAG, "onSensorChanged " + sensorEvent.values[0]);
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        SensorManager sensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
        List<Sensor> liste = sensorManager.getSensorList(Sensor.TYPE_ALL);
        if (BuildConfig.DEBUG) {
            for (Sensor currentSensor : liste) {
                Log.d(TAG, "onCreate sensor " + currentSensor);
            }
        }

        mProximitySensor = sensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);

        mSensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
    }
    @Override
    protected void onResume() {
        super.onResume();
        mSensorManager.registerListener(mSensorEventListener, mProximitySensor, SensorManager.SENSOR_DELAY_NORMAL);
    }

    @Override
    protected void onPause() {
        super.onPause();
        mSensorManager.unregisterListener(mSensorEventListener, mProximitySensor);
    }

}
