package com.example.myapplicationnews.api;

import android.content.Context;

import com.readystatesoftware.chuck.ChuckInterceptor;

import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitService {
    private static Retrofit retrofit;

    public static <S> S createService(Context context, Class<S> serviceClass) {

        if (retrofit == null) {
            // OkHttpClient. Be conscious with the order
            OkHttpClient okHttpClient = new OkHttpClient()
                    .newBuilder()
                    .addInterceptor(new ChuckInterceptor(context))
                    .build();


            retrofit = new Retrofit.Builder()
                    .client(okHttpClient)
                    .baseUrl("https://newsapi.org/v2/")
                    .addConverterFactory(GsonConverterFactory.create())
                    .build();
        }

        return retrofit.create(serviceClass);
    }
}
