package com.example.myapplicationnews.api;

import android.content.Context;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;

import com.example.myapplicationnews.api.model.NewsResponse;

public class NewsViewModel extends ViewModel {

    private MutableLiveData<NewsResponse> mutableLiveData;
    private NewsRepository newsRepository;

    public void init(Context context){
        if (mutableLiveData != null){
            return;
        }
        newsRepository = NewsRepository.getInstance(context);
        mutableLiveData = newsRepository.getNews("fr", "96c6792fdad6434fbc3a893daba40e0f");
    }

    public LiveData<NewsResponse> getNewsRepository() {
        return mutableLiveData;
    }
}