package com.example.myapplicationnews;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.bumptech.glide.Glide;
import com.example.myapplicationnews.api.model.Article;

public class NewsDetailActivity extends AppCompatActivity {
    private static final String TAG = "NewsDetailActivity";

    private Article article;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_news_detail);

        if (savedInstanceState != null) {
            article = savedInstanceState.getParcelable(Constants.INTENT_PARAMS_EXTRA_NEWS_CONTENT);
        } else {
            //get the Bundle out of the Intent...
            Bundle extras = getIntent().getExtras();
            article = (extras != null) ? extras.getParcelable(Constants.INTENT_PARAMS_EXTRA_NEWS_CONTENT) : null;
        }
        if (BuildConfig.DEBUG) {
            Log.d(TAG, "onCreate " + article);
        }

        TextView tvTitle = findViewById(R.id.activity_news_detail_textView_title);
        TextView tvPublishedAt = findViewById(R.id.activity_news_detail_textView_publishedAt);
        TextView tvAuthor = findViewById(R.id.activity_news_detail_textView_author);
        TextView tvDescription = findViewById(R.id.activity_news_detail_textView_description);
        ImageView ivImage = findViewById(R.id.activity_news_detail_imageView_image);

        tvTitle.setText(article.getTitle());
        tvPublishedAt.setText(article.getPublishedAt());
        tvAuthor.setText(article.getAuthor());
        tvDescription.setText(article.getContent());
        Glide.with(this).load(article.getUrlToImage()).into(ivImage);

        ivImage.setOnClickListener(v -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(article.getUrl()));
            startActivity(browserIntent);
        });
    }
}
