package com.example.myapplicationnews;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.util.Pair;
import androidx.lifecycle.ViewModelProvider;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.example.myapplicationnews.api.NewsViewModel;
import com.example.myapplicationnews.api.model.Article;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "MainActivity";

    private ArrayList<Article> articleArrayList = new ArrayList<>();
    private NewsAdapter newsAdapter;
    private RecyclerView rvHeadline;
    private NewsViewModel newsViewModel;
    private List<Article> newsArticles;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        rvHeadline = findViewById(R.id.rvNews);

        newsViewModel = new ViewModelProvider(this).get(NewsViewModel.class);
        newsViewModel.init(MainActivity.this);
        newsViewModel.getNewsRepository().observe(this, newsResponse -> {
            newsArticles = newsResponse.getArticles();
            articleArrayList.addAll(newsArticles);
            newsAdapter.notifyDataSetChanged();
        });

        setupRecyclerView(this);
    }

    private void setupRecyclerView(Context context) {
        if (newsAdapter == null) {
            newsAdapter = new NewsAdapter(MainActivity.this, articleArrayList);
            rvHeadline.setLayoutManager(new LinearLayoutManager(this));
            rvHeadline.setAdapter(newsAdapter);
            rvHeadline.setItemAnimator(new DefaultItemAnimator());
            rvHeadline.setNestedScrollingEnabled(true);


            rvHeadline.addOnItemTouchListener(
                    new RecyclerItemClickListener(context, rvHeadline, new RecyclerItemClickListener.OnItemClickListener() {
                        @Override
                        public void onItemClick(View view, int position) {
                            if (BuildConfig.DEBUG) {
                                Log.d(TAG, "onItemClick " + position);
                                Log.d(TAG, "onItemClick " + newsArticles.get(position));
                            }
                            Intent intent = new Intent(MainActivity.this, NewsDetailActivity.class);

                            intent.putExtra(Constants.INTENT_PARAMS_EXTRA_NEWS_CONTENT, newsArticles.get(position));

                            // Check if we're running on Android 5.0 or higher
                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                                if (BuildConfig.DEBUG) {
                                    Log.d(TAG, "onItemClick transition activated");
                                }

                                //ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation(MainActivity.this, (View) view.findViewById(R.id.item_news_imageView_image), "image");

                                Pair<View, String> p1 = Pair.create(view.findViewById(R.id.item_news_imageView_image), "image");
                                Pair<View, String> p2 = Pair.create(view.findViewById(R.id.item_news_textView_title), "title");
//                                Pair<View, String> p3 = Pair.create(view.findViewById(R.id.item_news_textView_description), "description");
                                ActivityOptionsCompat options = ActivityOptionsCompat.
                                        makeSceneTransitionAnimation(MainActivity.this, p1, p2);


                                startActivity(intent, options.toBundle());
                            } else {
                                startActivity(intent);
                            }


                        }

                        @Override
                        public void onLongItemClick(View view, int position) {
                            // do whatever
                            if (BuildConfig.DEBUG) {
                                Log.d(TAG, "onLongItemClick " + position);
                            }
                        }
                    })
            );
        } else {
            newsAdapter.notifyDataSetChanged();
        }
    }
}
