package com.example.phonecall;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;

public class MainActivity extends AppCompatActivity {
    /**
     * Id to identify a request to allows the application to initiate a phone call without going through the Dialer user interface for the user to confirm the call.
     */
    private static final int REQUEST_CALL_PHONE = 1000; // Any value can be used here

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // TODO : Add <uses-permission android:name="android.permission.CALL_PHONE"/> permission in the Manifest file.
        String url = "tel:"+"0612345678";
        Intent callIntent = new Intent(Intent.ACTION_DIAL, Uri.parse(url));
        startActivity(callIntent);


//        callAction();
    }

    private void callAction(){
        if (ContextCompat.checkSelfPermission(MainActivity.this,
                Manifest.permission.CALL_PHONE)
                != PackageManager.PERMISSION_GRANTED) {

            // Permission is not granted
            // Should we show an explanation?
            if (ActivityCompat.shouldShowRequestPermissionRationale(MainActivity.this,
                    Manifest.permission.CALL_PHONE)) {
                // Show an explanation to the user *asynchronously* -- don't block
                // this thread waiting for the user's response! After the user
                // sees the explanation, try again to request the permission.
            } else {
                // No explanation needed; request the permission
                ActivityCompat.requestPermissions(MainActivity.this,
                        new String[]{Manifest.permission.CALL_PHONE},
                        REQUEST_CALL_PHONE);

                // REQUEST_CALL_PHONE is an
                // app-defined int constant. The callback method gets the
                // result of the request.
            }
        } else {
            // Permission has already been granted, do to the job/
            actionToBeCalled();
        }
    }


    @Override
    public void onRequestPermissionsResult(int requestCode,
    String permissions[], int[] grantResults) {
        switch (requestCode) {
            case REQUEST_CALL_PHONE: {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    // permission was granted, great! Do the job that need permission.
                    actionToBeCalled();
                } else {
                    // permission denied, boo!
                    // TODO : Disable the functionality that depends on this permission.
                }
                return;
            }

            // other 'case' lines to check for other
            // permissions this app might request.

            default :
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @SuppressLint("MissingPermission")
    private void actionToBeCalled(){
        String url = "tel:"+"0612345678";
        Intent callIntent = new Intent(Intent.ACTION_CALL, Uri.parse(url));
        startActivity(callIntent);
    }
}
