package com.example.customview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

/**
 * Display a simple compass view.
 */
public class Compass extends View {
    private int mAngle = 0;
    private static final String TAG = "Compass";

    public Compass(Context context) {
        super(context);
        init(null, 0);
    }

    public Compass(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(attrs, 0);
    }

    public Compass(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {

        // Update TextPaint and text measurements from attributes
        invalidateTextPaintAndMeasurements();
    }

    private void invalidateTextPaintAndMeasurements() {

    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int cx = getWidth() / 2;
        int cy = getHeight() / 2;

        Paint paint = new Paint();

        // Définir la flèche
        Path northPath = new Path();
        northPath.moveTo(0, -cy);
        northPath.lineTo(-10, 0);
        northPath.lineTo(10, 0);
        northPath.close();

        // Dessiner le cercle de fond
        // Définir le rectangle contenant le cercle que l'on va dessiner
        RectF pitchOval = new RectF(0, 0, getWidth(), getHeight());

        paint.setColor(Color.BLACK);
        canvas.drawArc(pitchOval, 0, 360, false, paint);

        canvas.translate(cx, cy);
        canvas.rotate(mAngle);
        paint.setColor(Color.RED);
        canvas.drawPath(northPath, paint);
    }

    public void setmAngle(int mAngle) {
        this.mAngle = mAngle;
        invalidateTextPaintAndMeasurements();
    }
}
