package com.example.contentproviderclient;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.UserDictionary;
import android.util.Log;

import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "MainActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Defines a new Uri object that receives the result of the insertion
        Uri newUri;

        // Defines an object to contain the new values to insert
        ContentValues newValues = new ContentValues();

        /*
         * Sets the values of each column and inserts the word. The arguments to the "put"
         * method are "column name" and "value"
         */
        newValues.put(UserContract.MyDatas.KEY_COL_NAME, "SALAUN");
        newValues.put(UserContract.MyDatas.KEY_COL_FIRSTNAME, "Tristan");

        newUri = getContentResolver().insert(
                UserContract.MyDatas.CONTENT_URI,
                newValues
        );
        if (BuildConfig.DEBUG) {
            Log.d(TAG, "onCreate " + newUri);
        }


        Cursor cursor = getContentResolver().query(Uri.parse("content://com.exemple.contentprovider.provider"), null, null, null, null);
        if(cursor.moveToFirst()) {
            StringBuilder strBuild=new StringBuilder();
            while (!cursor.isAfterLast()) {
                strBuild.append("\n"+cursor.getString(0)+ "-"+ cursor.getString(1));
                cursor.moveToNext();
            }
            if(BuildConfig.DEBUG){
                Log.d(TAG, "onCreate " + strBuild);
            }
        }
    }
}
