package com.example.contentprovider;

import android.net.Uri;
import android.provider.BaseColumns;

public final class UserContract {
    // The Authority
    public static final String AUTHORITY = "com.exemple.contentprovider.provider";

    // The path to the data… and explain
    public static final String PATH_TO_DATA = "users"; //Vous pouvez déclarer plusieurs paths (les paths utilisent les /)


    public interface MyDatas extends BaseColumns {

        // The URI and explain, with example if you want
        public static final Uri CONTENT_URI = Uri.parse("content://" + UserContract.AUTHORITY + "/" + UserContract.PATH_TO_DATA);

        // My Column ID and the associated explanation for end-users
        public static final String KEY_COL_ID = _ID; // Mandatory

        // My Column Name and the associated explanation for end-users
        public static final String KEY_COL_NAME = "name";

        // My Column First Name and the associated explanation for end-users
        public static final String KEY_COL_FIRSTNAME = "firstName";

        // The index of the column ID
        public static final int ID_COLUMN = 1;
        // The index of the column NAME
        public static final int NAME_COLUMN = 2;
        // The index of the column FIRST NAME
        public static final int FIRSTNAME_COLUMN = 3;
    }
}
