package com.example.contentprovider;

import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Update;

public interface BaseDao<T> {
    /**
     * Insert an object in the database.
     *
     * @param obj the object to be inserted.
     */
    @Insert
    long insert(T obj);

    /**
     * Insert an array of objects in the database.
     *
     * @param obj the objects to be inserted.
     */
    @Insert
    void insertAll(T... obj);

    /**
     * Update an object from the database.
     *
     * @param obj the object to be updated
     */
    @Update
    void update(T obj);

    /**
     * Delete an object from the database
     *
     * @param obj the object to be deleted
     */
    @Delete
    void delete(T obj);


    //@Query("SELECT * from word_table LIMIT 1")
    //T[] getAnyItem();
}