package com.example.contentprovider;

import android.content.Context;

import androidx.test.ext.junit.runners.AndroidJUnit4;
import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

/**
 * Instrumented test, which will execute on an Android device.
 *
 * @see <a href="http://d.android.com/tools/testing">Testing documentation</a>
 */
@RunWith(AndroidJUnit4.class)
public class ExampleInstrumentedTest {
    UserDao userDao;

    @Before
    public void setup() {
        Context context = InstrumentationRegistry.getInstrumentation().getTargetContext();
        userDao = AppDatabase.getDatabase(context).userDao();
        userDao.deleteAll();
    }

    @Test
    public void databaseEmpty() {
        List<UserEntity> emptyList = userDao.getAll();
        assertNotNull(emptyList);
        assertEquals(0, emptyList.size());
    }

    @Test
    public void databaseInsert() {
        UserEntity currentUserEntity = new UserEntity();
        currentUserEntity.name = "SALAUN";
        currentUserEntity.firstname = "Tristan";
        userDao.insert(currentUserEntity);

        List<UserEntity> oneElementList = userDao.getAll();
        assertNotNull(oneElementList);
        assertEquals(1, oneElementList.size());

        assertEquals("Tristan", oneElementList.get(0).firstname);
        assertEquals("SALAUN", oneElementList.get(0).name);
    }
}
