// $ frida -l antiroot.js -U -f com.example.app --no-pause
// CHANGELOG by Tristuis1er
//  - I updated the RootPackages using the last version (Nov 16, 2021)
// CHANGELOG by Pichaya Morimoto (p.morimoto@sth.sh): 
//  - I added extra whitelisted items to deal with the latest versions 
// 						of RootBeer/Cordova iRoot as of August 6, 2019
//  - The original one just fucked up (kill itself) if Magisk is installed lol
// Credit & Originally written by: https://codeshare.frida.re/@dzonerzy/fridantiroot/
// If this isn't working in the future, check console logs, rootbeer src, or libtool-checker.so
Java.perform(function () {

    // TODO: getprop :
    // Call the method, BUT replace the sentitive values by the good ones from RootProperties array.
    // TODO: mount :
    // Replace the rw by ro in pathsThatShouldNotBeWritable list.
    // 

    var RootPackages = ["com.noshufou.android.su", "com.noshufou.android.su.elite", "eu.chainfire.supersu",
        "com.koushikdutta.superuser", "com.thirdparty.superuser", "com.yellowes.su", "com.koushikdutta.rommanager",
        "com.koushikdutta.rommanager.license", "com.dimonvideo.luckypatcher", "com.chelpus.lackypatch",
        "com.ramdroid.appquarantine", "com.ramdroid.appquarantinepro", "com.devadvance.rootcloak", "com.devadvance.rootcloakplus",
        "de.robv.android.xposed.installer", "com.saurik.substrate", "com.zachspong.temprootremovejb", "com.amphoras.hidemyroot",
        "com.amphoras.hidemyrootadfree", "com.formyhm.hiderootPremium", "com.formyhm.hideroot", "me.phh.superuser",
        "eu.chainfire.supersu.pro", "com.kingouser.com", "com.android.vending.billing.InAppBillingService.COIN", "com.topjohnwu.magisk",
        "com.kingroot.kinguser", "com.kingo.root", "com.smedialink.oneclickroot", "com.zhiqupk.root.global", "com.alephzain.framaroot",
        // Dangerous packages
            "com.android.vending.billing.InAppBillingService.LUCK", "com.chelpus.luckypatcher","com.blackmartalpha",
            "org.blackmart.market", "com.allinone.free", "com.repodroid.app", "org.creeplays.hack", "com.baseappfull.fwd",
            "com.zmapp", "com.dv.marketmod.installer", "org.mobilism.android", "com.android.wp.net.log","com.android.camera.update",
            "cc.madkite.freedom", "com.solohsu.android.edxp.manager", "org.meowcat.edxposed.manager","com.xmodgame",
            "com.cih.game_cih", "com.charles.lpoqasert","catch_.me_.if_.you_.can_",
        // knownRootCloakingPackages
        "com.devadvance.rootcloak", "com.devadvance.rootcloakplus", "de.robv.android.xposed.installer", "com.saurik.substrate",
            "com.zachspong.temprootremovejb", "com.amphoras.hidemyroot", "com.amphoras.hidemyrootadfree",
            "com.formyhm.hiderootPremium", "com.formyhm.hideroot"
    ];

    // Paths that can be checked :
    //  "/data/local/",
    //  "/data/local/bin/",
    //  "/data/local/xbin/",
    //  "/sbin/",
    //  "/su/bin/",
    //  "/system/bin/",
    //  "/system/bin/.ext/",
    //  "/system/bin/failsafe/",
    //  "/system/sd/xbin/",
    //  "/system/usr/we-need-root/",
    //  "/system/xbin/",
    //  "/cache/",
    //  "/data/",
    //  "/dev/"

    var RootBinaries = ["su", "busybox", "supersu", "Superuser.apk", "KingoUser.apk", "SuperSu.apk", "magisk"];

    var RootProperties = {
        "ro.build.selinux": "1",
        "ro.debuggable": "0",
        "service.adb.root": "0",
        "ro.secure": "1"
    };

    // TODO: protect pathsThatShouldNotBeWritable
    // "/system",
    // "/system/bin",
    // "/system/sbin",
    // "/system/xbin",
    // "/vendor/bin",
    // "/sbin",
    // "/etc", 

    var RootPropertiesKeys = [];

    for (var k in RootProperties) RootPropertiesKeys.push(k);

    var PackageManager = Java.use("android.app.ApplicationPackageManager");

    var Runtime = Java.use('java.lang.Runtime');

    var NativeFile = Java.use('java.io.File');

    var String = Java.use('java.lang.String');

    var SystemProperties = Java.use('android.os.SystemProperties');

    var BufferedReader = Java.use('java.io.BufferedReader');

    var ProcessBuilder = Java.use('java.lang.ProcessBuilder');

    var StringBuffer = Java.use('java.lang.StringBuffer');

    var loaded_classes = Java.enumerateLoadedClassesSync();

    //send("ROOT: Loaded " + loaded_classes.length + " classes!");
    //send(JSON.stringify({
    //    type: 'root',
    //    timestamp: Date.now(),
    //    sub_type: 'StartInfo',
    //    value: loaded_classes.length
    //}));
    var useKeyInfo = false;

    var useProcessManager = false;

    //send("ROOT: loaded: " + loaded_classes.indexOf('java.lang.ProcessManager'));
    //send(JSON.stringify({
    //    type: 'root',
    //    timestamp: Date.now(),
    //    sub_type: 'ProcessManagerIsLoaded',
    //    value: loaded_classes.indexOf('java.lang.ProcessManager') != -1
    //}));

    if (loaded_classes.indexOf('java.lang.ProcessManager') != -1) {
        try {
            //useProcessManager = true;
            //var ProcessManager = Java.use('java.lang.ProcessManager');
        } catch (err) {
            //send("ProcessManager Hook failed: " + err);

            //send(JSON.stringify({
            //    type: 'root',
            //    timestamp: Date.now(),
            //    sub_type: 'HookFailed',
            //    value: 'ProcessManager',
            //    error: err
            //}));
        }
    } else {
        //send("ROOT: ProcessManager hook not loaded");
        //send(JSON.stringify({
        //    type: 'root',
        //    timestamp: Date.now(),
        //    sub_type: 'HookNotLoaded',
        //    value: 'ProcessManager',
        //}));
    }

    var KeyInfo = null;

    if (loaded_classes.indexOf('android.security.keystore.KeyInfo') != -1) {
        try {
            //useKeyInfo = true;
            //var KeyInfo = Java.use('android.security.keystore.KeyInfo');
        } catch (err) {
            //send("ROOT: KeyInfo Hook failed: " + err);
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'HookFailed',
                value: 'KeyInfo',
                error: err
            }));
        }
    } else {
        //send("ROOT: KeyInfo hook not loaded");
        send(JSON.stringify({
            type: 'root',
            timestamp: Date.now(),
            sub_type: 'HookNotLoaded',
            value: 'KeyInfo',
        }));
    }

    PackageManager.getPackageInfo.overload('java.lang.String', 'int').implementation = function (pname, flags) {
        var shouldFakePackage = (RootPackages.indexOf(pname) > -1);
        if (shouldFakePackage) {
            //send("ROOT: Bypass root check for package: " + pname);
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'PackageInfo',
                value: pname,
            }));


            pname = "set.package.name.to.a.fake.one.so.we.can.bypass.it";
        }
        return this.getPackageInfo.call(this, pname, flags);
    };

    NativeFile.exists.implementation = function () {
        var name = NativeFile.getName.call(this);
        var shouldFakeReturn = (RootBinaries.indexOf(name) > -1);
        if (shouldFakeReturn) {
            //send("ROOT: Bypass return value for binary: " + name);
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'FileExist',
                value: name,
            }));

            return false;
        } else {
            return this.exists.call(this);
        }
    };

    var exec = Runtime.exec.overload('[Ljava.lang.String;');
    var exec1 = Runtime.exec.overload('java.lang.String');
    var exec2 = Runtime.exec.overload('java.lang.String', '[Ljava.lang.String;');
    var exec3 = Runtime.exec.overload('[Ljava.lang.String;', '[Ljava.lang.String;');
    var exec4 = Runtime.exec.overload('[Ljava.lang.String;', '[Ljava.lang.String;', 'java.io.File');
    var exec5 = Runtime.exec.overload('java.lang.String', '[Ljava.lang.String;', 'java.io.File');

    exec5.implementation = function (cmd, env, dir) {
        if (cmd == "getprop") {
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec5 clean getprop',
                value: cmd
            }));
            return getpropHandler(exec5.call(this, cmd, env, dir));
        }
        if (cmd.indexOf("getprop") != -1 || cmd == "mount" || cmd.indexOf("build.prop") != -1 || cmd == "id" || cmd == "sh") {
            var fakeCmd = "grep";
            //send("ROOT: Bypass " + cmd + " command");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec5',
                value: cmd
            }));

            return exec1.call(this, fakeCmd);
        }
        if (cmd == "su") {
            var fakeCmd = "justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled";
            //send("ROOT: Bypass " + cmd + " command");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec5',
                value: cmd
            }));

            return exec1.call(this, fakeCmd);
        }
        if (cmd == "which") {
            var fakeCmd = "justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled";
            //send("ROOT: Bypass which command");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec5',
                value: cmd
            }));
            return exec1.call(this, fakeCmd);
        }
        return exec5.call(this, cmd, env, dir);
    };

    exec4.implementation = function (cmdarr, env, file) {
        for (var i = 0; i < cmdarr.length; i = i + 1) {
            var tmp_cmd = cmdarr[i];
            if (tmp_cmd == "getprop") {
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec4 clean getprop',
                    value: cmd
                }));
                return getpropHandler(exec4.call(this, cmdarr, env, file));
            }
            if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id" || tmp_cmd == "sh") {
                var fakeCmd = "grep";
                send("ROOT: Bypass " + cmdarr + " command");
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec4',
                    value: tmp_cmd
                }));
                return exec1.call(this, fakeCmd);
            }

            if (tmp_cmd == "su") {
                var fakeCmd = "justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled";
                //send("ROOT: Bypass " + cmdarr + " command");
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec4',
                    value: tmp_cmd
                }));
                return exec1.call(this, fakeCmd);
            }
        }
        return exec4.call(this, cmdarr, env, file);
    };

    exec3.implementation = function (cmdarr, envp) {
        for (var i = 0; i < cmdarr.length; i = i + 1) {
            var tmp_cmd = cmdarr[i];
            if (tmp_cmd == "getprop") {
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec3 clean getprop',
                    value: cmd
                }));
                return getpropHandler(exec3.call(this, cmdarr, envp));
            }
            if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id" || tmp_cmd == "sh") {
                var fakeCmd = "grep";
                //send("ROOT: Bypass " + cmdarr + " command");
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec3',
                    value: tmp_cmd
                }));
                return exec1.call(this, fakeCmd);
            }

            if (tmp_cmd == "su") {
                var fakeCmd = "justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled";
                //send("ROOT: Bypass " + cmdarr + " command");
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec3',
                    value: tmp_cmd
                }));
                return exec1.call(this, fakeCmd);
            }
        }
        return exec3.call(this, cmdarr, envp);
    };

    exec2.implementation = function (cmd, env) {
        if (cmd == "getprop") {
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec2 clean getprop',
                value: cmd
            }));
            return getpropHandler(exec2.call(this, cmd, env));
        }
        if (cmd.indexOf("getprop") != -1 || cmd == "mount" || cmd.indexOf("build.prop") != -1 || cmd == "id" || cmd == "sh") {
            var fakeCmd = "grep";
            //send("ROOT: Bypass " + cmd + " command");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec2',
                value: cmd
            }));
            return exec1.call(this, fakeCmd);
        }
        if (cmd == "su") {
            var fakeCmd = "justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled";
            //send("ROOT: Bypass " + cmd + " command");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec2',
                value: cmd
            }));
            return exec1.call(this, fakeCmd);
        }
        return exec2.call(this, cmd, env);
    };

    exec.implementation = function (cmd) {
        for (var i = 0; i < cmd.length; i = i + 1) {
            var tmp_cmd = cmd[i];
            if (tmp_cmd == "getprop") {
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec clean getprop',
                    value: cmd
                }));
                return getpropHandler(exec.call(this, cmd));
            }
            if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id" || tmp_cmd == "sh") {
                var fakeCmd = "grep";
                //send("ROOT: Bypass " + cmd + " command");
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec',
                    value: tmp_cmd
                }));
                return exec1.call(this, fakeCmd);
            }

            if (tmp_cmd == "su") {
                var fakeCmd = "justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled";
                //send("ROOT: Bypass " + cmd + " command");
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Exec',
                    value: tmp_cmd
                }));
                return exec1.call(this, fakeCmd);
            }
        }

        return exec.call(this, cmd);
    };

    exec1.implementation = function (cmd) {
        if (cmd == "getprop") {
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec1 clean getprop',
                value: cmd
            }));
            return getpropHandler(exec1.call(this, cmd));
        }
        if (cmd.indexOf("getprop") != -1 || cmd == "mount" || cmd.indexOf("build.prop") != -1 || cmd == "id" || cmd == "sh") {
            var fakeCmd = "grep";
            //send("ROOT: Bypass " + cmd + " command");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec1',
                value: cmd
            }));
            return exec1.call(this, fakeCmd);
        }
        if (cmd == "su") {
            var fakeCmd = "justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled";
            //send("ROOT: Bypass " + cmd + " command");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'Exec1',
                value: cmd
            }));
            return exec1.call(this, fakeCmd);
        }
        return exec1.call(this, cmd);
    };

    String.contains.implementation = function (name) {
        if (name == "test-keys") {
            //send("ROOT: Bypass test-keys check");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'String',
                value: name.toString(),
            }));

            return false;
        }
        return this.contains.call(this, name);
    };

    var get = SystemProperties.get.overload('java.lang.String');

    get.implementation = function (name) {
        if (RootPropertiesKeys.indexOf(name) != -1) {
            //send("ROOT: Bypass " + name);
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'SystemProperties.get',
                value: name
            }));
            return RootProperties[name];
        }
        return this.get.call(this, name);
    };

    Interceptor.attach(Module.findExportByName("libc.so", "fopen"), {
        onEnter: function (args) {
            var path1 = Memory.readCString(args[0]);
            var path = path1.split("/");
            var executable = path[path.length - 1];
            var shouldFakeReturn = (RootBinaries.indexOf(executable) > -1)
            if (shouldFakeReturn) {
                Memory.writeUtf8String(args[0], "/ggezxxx");
                //send("ROOT: Bypass native fopen >> "+path1);
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Native.fopen',
                    value: path1
                }));
            }
        },
        onLeave: function (retval) {

        }
    });

    Interceptor.attach(Module.findExportByName("libc.so", "system"), {
        onEnter: function (args) {
            var cmd = Memory.readCString(args[0]);
            send("ROOT: SYSTEM CMD: " + cmd);
            if (cmd.indexOf("getprop") != -1 || cmd == "mount" || cmd.indexOf("build.prop") != -1 || cmd == "id") {
                //send("ROOT: Bypass native system: " + cmd);
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Native.system',
                    value: cmd
                }));
                Memory.writeUtf8String(args[0], "grep");
            }
            if (cmd == "su") {
                //send("ROOT: Bypass native system: " + cmd);
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'Native.system',
                    value: cmd
                }));
                Memory.writeUtf8String(args[0], "justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled");
            }
        },
        onLeave: function (retval) {

        }
    });

    /*

    TO IMPLEMENT:

    Exec Family

    int execl(const char *path, const char *arg0, ..., const char *argn, (char *)0);
    int execle(const char *path, const char *arg0, ..., const char *argn, (char *)0, char *const envp[]);
    int execlp(const char *file, const char *arg0, ..., const char *argn, (char *)0);
    int execlpe(const char *file, const char *arg0, ..., const char *argn, (char *)0, char *const envp[]);
    int execv(const char *path, char *const argv[]);
    int execve(const char *path, char *const argv[], char *const envp[]);
    int execvp(const char *file, char *const argv[]);
    int execvpe(const char *file, char *const argv[], char *const envp[]);

    */


    BufferedReader.readLine.overload().implementation = function () {
        var text = this.readLine.call(this);
        if (text === null) {
            // just pass , i know it's ugly as hell but test != null won't work :(
        } else {
            var shouldFakeRead = (text.indexOf("ro.build.tags=test-keys") > -1);
            if (shouldFakeRead) {
                //send("ROOT: Bypass build.prop file read");
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'BuildPropFile',
                    value: text
                }));
                text = text.replace("ro.build.tags=test-keys", "ro.build.tags=release-keys");
            }
        }
        return text;
    };

    var executeCommand = ProcessBuilder.command.overload('java.util.List');

    ProcessBuilder.start.implementation = function () {
        var cmd = this.command.call(this);
        var shouldModifyCommand = false;
        for (var i = 0; i < cmd.size(); i = i + 1) {
            var tmp_cmd = cmd.get(i).toString();
            if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd.indexOf("mount") != -1 || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd.indexOf("id") != -1) {
                shouldModifyCommand = true;
                //send("ROOT: Bypass ProcessBuilder found " + tmp_cmd + " " + cmd.get(i+1).toString() + " " + this.start.call(this));
                send(JSON.stringify({
                    type: 'root',
                    timestamp: Date.now(),
                    sub_type: 'ProcessBuilder',
                    value: tmp_cmd + " " + cmd.get(i + 1).toString() + " " + this.start.call(this)
                }));

            }
        }
        if (shouldModifyCommand) {
            //send("ROOT: Bypass ProcessBuilder " + cmd);
            this.command.call(this, ["grep"]);
            return this.start.call(this);
        }
        if (cmd.indexOf("su") != -1) {
            //send("ROOT: Bypass ProcessBuilder su " + cmd);
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'ProcessBuilder',
                value: cmd
            }));
            this.command.call(this, ["justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled"]);
            return this.start.call(this);
        }

        return this.start.call(this);
    };

    if (useProcessManager) {
        var ProcManExec = ProcessManager.exec.overload('[Ljava.lang.String;', '[Ljava.lang.String;', 'java.io.File', 'boolean');
        var ProcManExecVariant = ProcessManager.exec.overload('[Ljava.lang.String;', '[Ljava.lang.String;', 'java.lang.String', 'java.io.FileDescriptor', 'java.io.FileDescriptor', 'java.io.FileDescriptor', 'boolean');

        ProcManExec.implementation = function (cmd, env, workdir, redirectstderr) {
            var fake_cmd = cmd;
            for (var i = 0; i < cmd.length; i = i + 1) {
                var tmp_cmd = cmd[i];
                if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id") {
                    var fake_cmd = ["grep"];
                    //send("ROOT: Bypass " + cmdarr + " command");
                    send(JSON.stringify({
                        type: 'root',
                        timestamp: Date.now(),
                        sub_type: 'ProcessManager',
                        value: cmdarr
                    }));
                }

                if (tmp_cmd == "su") {
                    var fake_cmd = ["justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled"];
                    //send("ROOT: Bypass " + cmdarr + " command");
                    send(JSON.stringify({
                        type: 'root',
                        timestamp: Date.now(),
                        sub_type: 'ProcessManager',
                        value: cmdarr
                    }));
                }
            }
            return ProcManExec.call(this, fake_cmd, env, workdir, redirectstderr);
        };

        ProcManExecVariant.implementation = function (cmd, env, directory, stdin, stdout, stderr, redirect) {
            var fake_cmd = cmd;
            for (var i = 0; i < cmd.length; i = i + 1) {
                var tmp_cmd = cmd[i];
                if (tmp_cmd.indexOf("getprop") != -1 || tmp_cmd == "mount" || tmp_cmd.indexOf("build.prop") != -1 || tmp_cmd == "id") {
                    var fake_cmd = ["grep"];
                    //send("ROOT: Bypass " + cmdarr + " command");
                    send(JSON.stringify({
                        type: 'root',
                        timestamp: Date.now(),
                        sub_type: 'ProcessManager',
                        value: cmdarr
                    }));
                }

                if (tmp_cmd == "su") {
                    var fake_cmd = ["justafakecommandthatcannotexistsusingthisshouldthowanexceptionwheneversuiscalled"];
                    //send("ROOT: Bypass " + cmdarr + " command");
                    send(JSON.stringify({
                        type: 'root',
                        timestamp: Date.now(),
                        sub_type: 'ProcessManager',
                        value: tmp_cmd
                    }));
                }
            }
            return ProcManExecVariant.call(this, fake_cmd, env, directory, stdin, stdout, stderr, redirect);
        };
    }

    if (useKeyInfo) {
        KeyInfo.isInsideSecureHardware.implementation = function () {
            //send("ROOT: Bypass isInsideSecureHardware");
            send(JSON.stringify({
                type: 'root',
                timestamp: Date.now(),
                sub_type: 'KeyInfoIsInsideSecureHardware'
            }));
            return true;
        }
    }

    send(JSON.stringify({
        type: 'internal',
        timestamp: Date.now(),
        sub_type: 'scriptLoaded',
        value: 'bypass_root.js'
    }));

});


function getpropHandler(paragraph) {
	// This method will "patch" the return value of getprop call by a clean one.
    var returnValue = paragraph;
	for (var key in RootProperties) {
        //const key="ro.secure"
        let re = new RegExp(String.raw`\[${key}\]: \[\d\]`, "g");
        paragraph = paragraph.replace(re, `[${key}]: [${RootProperties[key]}]`)
      }
      return returnValue;
}