package formation05delegation

import kotlin.properties.ReadWriteProperty
import kotlin.reflect.KProperty

class LogDelegate<T> : ReadWriteProperty<Any, T?> {
    private var value: T? = null
    override fun getValue(thisRef: Any, property: KProperty<*>): T? {
        println("LOG get $value")
        return value
    }
    override fun setValue(thisRef: Any, property: KProperty<*>, value: T?) {
        println("LOG set : $value")
        this.value = value
    }
}

class Demo {
    var name by LogDelegate<String>()
}

val d = Demo()

fun main() {
    d.name = "Tristan"
    println(d.name)
}