package formation05delegation

interface Nameable {
    var name: String
    var firstName: String
    var companyName: String
    var cityName: String
}

class JackName : Nameable {
    override var name: String = "Jack"
    override var firstName: String = "Terence"
    override var companyName: String = "IBM"
    override var cityName: String = "London"
}

class TristanName : Nameable {
    override var name: String = "SALAUN"
    override var firstName: String = "Tristan"
    override var companyName: String = "STDev"
    override var cityName: String = "Marseille"
}

class LongDistanceRunner : Runnable {
    override fun run() {
        println("long")
    }
}

class ShortDistanceRunner : Runnable {
    override fun run() {
        println("short")
    }
}

class Person(name: Nameable, runner: Runnable) : Nameable by name, Runnable by runner

fun displayPerson(person: Person) {
    println("${person.firstName} ${person.name} of ${person.companyName} from ${person.cityName}")
    person.run()
}

fun main(args: Array<String>) {
    val person = Person(JackName(), LongDistanceRunner())
    displayPerson(person)
    val person2 = Person(TristanName(), ShortDistanceRunner())
    displayPerson(person2)
}